/*
 * qoi_traveltime.hh
 *
 *  Created on: 2013. 8. 23.
 *      Author: parkmh
 */

#ifndef QOI_TRAVELTIME_HH_
#define QOI_TRAVELTIME_HH_
#include <iostream>
#include <cmath>
template <int dim, typename DISC>
struct wipp_qoi_traveltime{
	typedef typename DISC::datatype datatype;
	typedef typename DISC::N N;
	typedef typename DISC::pos pos;
	datatype operator()(const DISC& disc, const NumVec<datatype>& u, const NumVec<datatype>& k) const{
		datatype qoi = 0.0;
		pos position, new_position, start, end, bstart, bend, h;
		N n;

		n = disc.n();
		start = disc.start();
		end = disc.end();
		position= (start + end)*0.5;
		datatype hx = disc.hx();
		double dt = 60.0*60.0*24.0*365.0*100.0;
		if (dim == 1){

		} else if (dim == 2){
			position[0] =  613350; position[1] = 3581800;
			start[0]  = 602700; start[1] = 3566500;
			end[0] = 624000; end[1] = 3597100;
			bstart[0] = start[0] + 7795;
			bstart[1] = start[1] + 12181;
			bend[0] = start[0]+14315;
			bend[1] = start[1]+18568;
			h[0] = (end[0]-start[0])/(double)n[0];
			h[1] = (end[1]-start[1])/(double)n[1];

			size_t ix = 0, iy = 0;
			size_t ix_old = 0, iy_old = 0;
			double vRight = .0, vLeft = .0, vUp = .0, vDown = .0;
			double fx, fy, ivx, ivy;
			double d, d2, grad, xint, yint;

			u.save("pressure_head.vec");
			k.save("transmissivity.vec");
			std::ofstream save;
			save.open("position",std::ios::out);

			save << position[0] << " " << position[1] ;
			while (1){
				ix = std::min((size_t)floor((position[0] - start[0])/h[0]),n[0]-1);
				iy = std::min((size_t)floor((position[1] - start[1])/h[1]),n[1]-1);
				if ((ix != ix_old)|(iy!=iy_old)){
					Velocity(vRight, vLeft, vUp, vDown, u, k, n, h, position, ix, iy);
				}
//				std::cout << "Velocity[R L U D] : " << vRight << ", " << vLeft << ", " << vUp << ", " << vDown << std::endl;
				fx = remainder(position[0]-start[0],h[0])/h[0];
				fy = remainder(position[1]-start[1],h[1])/h[1];
				if (fx < 0) fx += 1.0;
				if (fy < 0) fy += 1.0;
				ivx = (1-fx)*vLeft + fx*vRight;
				ivy = (1-fy)*vDown + fy*vUp;
				save << " " << ivx << " " << ivy <<  " " << fx << " " << fy << std::endl;
//				std::cout << "ivx : " << ivx << ", ivy : " << ivy << std::endl;
				new_position[0] = position[0] + dt*ivx;
				new_position[1] = position[1] + dt*ivy;
//				std::cout << "new position " << new_position << std::endl<<std::endl;
//				std::cout << "bstart" << bstart << ", bend" << bend << std::endl;
				if ((new_position[0] > bstart[0])&(new_position[1] > bstart[1])&
						(new_position[0] < bend[0])&(new_position[1] < bend[1])	){
					qoi += dt;
					position = new_position;
//					save << position[0] << " " << position[1];
					ix_old = ix;
					iy_old = iy;
				} else {
//					std::cout << std::endl;
					d = sqrt((new_position[0]-position[0])*(new_position[0]-position[0])+(new_position[1]-position[1])*(new_position[1]-position[1]));
					grad = (new_position[1]-position[1])/(new_position[0]-position[0]);

					yint = new_position[1] + grad*(bend[0]-new_position[0]);
					if ((yint>bstart[1]) & (yint<bend[1]) & (ivx > .0)){
						new_position[0] = bend[0];
						new_position[1] = yint;
						d2 = sqrt((new_position[0]-position[0])*(new_position[0]-position[0])+(new_position[1]-position[1])*(new_position[1]-position[1]));
						qoi += d2/d*dt;
						break;
					}

					yint = new_position[1] + grad*(bstart[0]-new_position[0]);
					if ((yint>bstart[1])& (yint<bend[1]) & (ivx < .0)){
						new_position[0] = bstart[0];
						new_position[1] = yint;
						d2 = sqrt((new_position[0]-position[0])*(new_position[0]-position[0])+(new_position[1]-position[1])*(new_position[1]-position[1]));
						qoi += d2/d*dt;
						break;
					}

					xint = new_position[0] + 1.0/grad*(bstart[1]-new_position[1]);
					if ((xint>bstart[0])&(xint<bend[0])&(ivy < 0.0)){
						new_position[0] = xint;
						new_position[1] = bstart[1];
						d2 = sqrt((new_position[0]-position[0])*(new_position[0]-position[0])+(new_position[1]-position[1])*(new_position[1]-position[1]));
						qoi += d2/d*dt;
						break;
					}

					xint = new_position[0] + 1.0/grad*(bend[1]-new_position[1]);
					if ((xint>bstart[0])&(xint<bend[0]) & (ivy > 0.0)){
						new_position[0] = xint;
						new_position[1] = bend[1];
						d2 = sqrt((new_position[0]-position[0])*(new_position[0]-position[0])+(new_position[1]-position[1])*(new_position[1]-position[1]));
						qoi += d2/d*dt;
						break;
					}

				}


			}
			position = new_position;
			save << position[0] << " " << position[1] << std::endl;
			save.close();

		} else if (dim == 3){

		}
//		std::cout << qoi/dt*100 << " years" << std::endl;
		qoi = log10(qoi);
		return qoi;
	}

	inline void Velocity(datatype& vRight, datatype& vLeft, datatype& vUp, datatype& vDown,
			const NumVec<datatype>& u, const NumVec<datatype>& k,const N& n,
			const pos& h, const pos& position,
			const size_t &ix, const size_t& iy) const {
//		std::cout << "Velocity" << std::endl;
//		std::cout << "[" << ix << "][" << iy << "] => ";
		const datatype rho = 0.16;	// porosity
		const datatype b = 8.; 		// thickness
		size_t right, left, up, down, center;
		center = n[0]*iy+ix;
		right = center + 1;
		left = center - 1;
		up = center + n[0];
		down = center - n[0];
		const datatype c = -1.0/(rho*b);
		if (ix == n[0] - 1){
			vRight = 0.5*c *(Boundary(position[0]+h[0],position[1])-u[center])/h[0]* k[center];
		} else{
			vRight = c*(u[right]-u[center])/h[0] * (2.0*k[right]*k[center])/(k[right]+k[center]);
		}

		if (ix == 0){
			vLeft = 0.5*c *(u[center]-Boundary(position[0]-h[0],position[1]))/h[0]* k[center];
		} else{
			vLeft = c*(u[center]-u[left])/h[0] * (2.0*k[center]*k[left])/(k[center]+k[left]);
		}

		if (iy == n[1] - 1){
			vUp = 0.5*c *(Boundary(position[0],position[1]+h[1])-u[center])/h[1]* k[center];
		} else{
			vUp = c*(u[up]-u[center])/h[1] * (2.0*k[up]*k[center])/(k[up]+k[center]);
		}

		if (iy == 0){
			vDown = 0.5*c *(u[center]-Boundary(position[0],position[1]-h[1]))/h[1]* k[center];
		} else{
			vDown = c*(u[center]-u[down])/h[1] * (2.0*k[center]*k[down])/(k[center]+k[down]);
		}
	}

	inline datatype Boundary(const datatype &x, const datatype &y) const {
		return 1134.61*exp(-.5*(
				(x-611011.89)*(x-611011.89)/(73559.35 *73559.35)
				+(y-3780891.50)*(y-3780891.50)/(313474.40*313474.40)));}
};


#endif /* QOI_TRAVELTIME_HH_ */
